boolean g_bMouseDown = false;

class Point2D {
  int x;
  int y;

  Point2D()
  {
    x = 0;
    y = 0;
  }

  Point2D(int x1, int y1)
  {
    x = x1;
    y = y1;
  }


}


class WavEditor
{

  Point2D m_MainDrawPos;
  int m_iMainPixelSize;
  Point2D m_MainFrameDrawSize;

  WavEditor()
  {
    m_MainDrawPos = new Point2D(20, 20);
    m_iMainPixelSize = 10;
  }

  void processMainFrame(SelectionInfo selected)
  { 

    if (g_DataManager.loadedData())
    {   
      m_MainFrameDrawSize = drawFrame(selected.getFrame(), m_MainDrawPos.x, m_MainDrawPos.y, m_iMainPixelSize);
      modifyMainFrame(); 
    }
    else
    {
      Point2D frameSize = getFrameSize(m_iMainPixelSize);
      fill(53);
      stroke(153);
      rect(m_MainDrawPos.x, m_MainDrawPos.y, frameSize.x, frameSize.y);      
    }  
  }



  void modifyMainFrame()
  {

    if (!mouseDown()) return;

    boolean bInGrid = false;

    int iLocalMouseX = mouseX - m_MainDrawPos.x;
    int iLocalMouseY = mouseY - m_MainDrawPos.y;

    if ((iLocalMouseX > 0) && (iLocalMouseX < m_MainFrameDrawSize.x))
    {
      if ((iLocalMouseY > 0) && (iLocalMouseY < m_MainFrameDrawSize.y))
      {
        bInGrid = true;
      }
    }

    if (bInGrid)
    {
      Point2D p = getPointInGrid(iLocalMouseX, iLocalMouseY, 10);

      g_DataManager.setData(g_SelectionInfo, p.x, 16-p.y);
    }


  }


  Point2D getFrameSize(int iPixelSize)
  {
    Point2D frameSize = new Point2D();

    frameSize.x = g_iFrameLength*iPixelSize;
    frameSize.y = 16*iPixelSize;

    return frameSize;

  }

  // returns width and height of the drawn frame
  Point2D drawFrame(int iFrame, int iDrawX, int iDrawY, int iPixelSize)
  {

    return drawFrame(g_DataManager.getFrame(g_SelectionInfo.getInstrument(), iFrame), iDrawX, iDrawY, iPixelSize);

  }
  
  
  Point2D drawFrame(Frame f, int iDrawX, int iDrawY, int iPixelSize)
  {

    Point2D frameSize = getFrameSize(iPixelSize);

    fill(53);
    stroke(153);
    rect(iDrawX, iDrawY, frameSize.x, frameSize.y);
    
    noStroke();

    for (int i = 0; i < g_iFrameLength; i++)
    {
      int iValue = f.getData(i) + 1;

      int iXPos = iDrawX + (i * iPixelSize);

      int iYPos = iDrawY + (16 * iPixelSize) - (iValue * iPixelSize);

      fill(143);
      rect(iXPos, iYPos, iPixelSize, iValue*iPixelSize);   

      fill(243);
      rect(iXPos, iYPos, iPixelSize, iPixelSize);
    }

    return frameSize;

  }
  

  Point2D getPointInGrid(int x, int y, int iPixelSize)
  {
    Point2D p = new Point2D();
    p.x = x;
    p.y = y;
    return getPointInGrid(p, iPixelSize);
  }


  Point2D getPointInGrid(Point2D p, int iPixelSize)
  {

    Point2D rtn = new Point2D();

    rtn.x = floor(p.x/iPixelSize);
    rtn.y = floor(p.y/iPixelSize) + 1;

    return rtn;

  }



}
